/*------------------------------------------------------------------------------*
 * File Name: CallingOCFromLabTalkEx.c											*
 * Creation: BT & GJL 8/25/03													*
 * Purpose: OriginC Source C file containing CallingOCFromLabTalkEx.c examples.	*
 * Copyright (c) OriginLab Corp.	2003										*
 * All Rights Reserved															*
 *------------------------------------------------------------------------------*/

#include <Origin.h>

// Casting of Arguments
void PrintNumeric(int ii)
{
	printf("The number is %d", ii);
}

// Operating on Scalors and Vectors
double CallOnceForeachElement(double a, double b)
{
	return a + b;
}

// Passing Strings with and without Substitution 
void PassString(string str)
{
	printf("The string is \"%s\"\n", str);
}

// Passing Vectors by Reference
vector PassVectorByReference(vector& vIn, double f)
{
	return (vIn * f);
}

// Passing an Array of Strings
vector PassArrayOfStrings(vector<string> vIn)
{
	vector vOut(vIn.GetSize());
	for(int ii = 0; ii < vIn.GetSize(); ii++)
		vOut[ii] = vIn[ii].GetLength();        
	return vOut;
}

// Returning a String
string GetErrorMessage(int iErrorCode)
{
	string str;
	str.Format("Error message %d", iErrorCode);
	return str;
}

// Returning a Vector
vector ReturnAVector(double f)
{
	vector vData = {0, 1, 2, 3, 4};
	return (vData * f);
}

void tt()
{
	vector vv(5);
	vv = ReturnAVector(12);
}

